/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.api.storage.IStorageProvider;
import com.raoulvdberge.refinedstorage.api.storage.StorageType;
import com.raoulvdberge.refinedstorage.api.storage.externalstorage.IExternalStorageContext;
import com.raoulvdberge.refinedstorage.api.storage.externalstorage.IExternalStorageProvider;
import com.raoulvdberge.refinedstorage.api.storage.externalstorage.IStorageExternal;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.ICoverable;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.IGuiStorage;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.raoulvdberge.refinedstorage.apiimpl.storage.cache.StorageCacheFluid;
import com.raoulvdberge.refinedstorage.apiimpl.storage.cache.StorageCacheItem;
import com.raoulvdberge.refinedstorage.tile.TileExternalStorage;
import com.raoulvdberge.refinedstorage.tile.config.FilterConfig;
import com.raoulvdberge.refinedstorage.tile.config.FilterType;
import com.raoulvdberge.refinedstorage.tile.config.IAccessType;
import com.raoulvdberge.refinedstorage.tile.config.IPrioritizable;
import com.raoulvdberge.refinedstorage.tile.config.IRSFilterConfigProvider;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import com.raoulvdberge.refinedstorage.util.AccessTypeUtils;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;

public class NetworkNodeExternalStorage
extends NetworkNode
implements IStorageProvider,
IGuiStorage,
IPrioritizable,
IRSFilterConfigProvider,
IAccessType,
IExternalStorageContext,
ICoverable {
    public static final String ID = "external_storage";
    private static final String NBT_PRIORITY = "Priority";
    private static final String NBT_COVERS = "Covers";
    private int priority = 0;
    private final FilterConfig config = new FilterConfig.Builder(this).allowedFilterModeBlackAndWhitelist().filterModeBlacklist().allowedFilterTypeItemsAndFluids().filterTypeItems().filterSizeNine().compareDamageAndNbt().customFilterTypeSupplier(ft -> this.world.field_72995_K ? FilterType.values()[TileExternalStorage.TYPE.getValue()] : ft).onFilterTypeChanged(ft -> {
        if (this.network != null) {
            this.updateStorage(this.network);
        }
    }).build();
    private AccessType accessType = AccessType.INSERT_EXTRACT;
    private int networkTicks;
    private final CoverManager coverManager = new CoverManager(this);
    private final List<IStorageExternal<ItemStack>> itemStorages = new CopyOnWriteArrayList<IStorageExternal<ItemStack>>();
    private final List<IStorageExternal<FluidStack>> fluidStorages = new CopyOnWriteArrayList<IStorageExternal<FluidStack>>();

    public NetworkNodeExternalStorage(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.externalStorageUsage + (this.itemStorages.size() + this.fluidStorages.size()) * RS.INSTANCE.config.externalStoragePerStorageUsage;
    }

    @Override
    public void onConnectedStateChange(INetwork network, boolean state) {
        super.onConnectedStateChange(network, state);
        this.updateStorage(network);
    }

    @Override
    public void updateNetworkNode() {
        super.updateNetworkNode();
        if (this.canUpdate()) {
            if (this.networkTicks++ == 0) {
                this.updateStorage(this.network);
                return;
            }
            for (IStorageExternal<ItemStack> iStorageExternal : this.itemStorages) {
                iStorageExternal.update(this.network);
            }
            for (IStorageExternal<ItemStack> iStorageExternal : this.fluidStorages) {
                iStorageExternal.update(this.network);
            }
        }
    }

    @Override
    protected void onDirectionChanged() {
        super.onDirectionChanged();
        if (this.network != null) {
            this.updateStorage(this.network);
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        if (tag.func_74764_b(NBT_COVERS)) {
            this.coverManager.readFromNbt(tag.func_150295_c(NBT_COVERS, 10));
        }
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        tag.func_74782_a(NBT_COVERS, (NBTBase)this.coverManager.writeToNbt());
        return tag;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_PRIORITY, this.priority);
        AccessTypeUtils.writeAccessType(tag, this.accessType);
        tag.func_74782_a("config", (NBTBase)this.config.writeToNBT(new NBTTagCompound()));
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_PRIORITY)) {
            this.priority = tag.func_74762_e(NBT_PRIORITY);
        }
        this.accessType = AccessTypeUtils.readAccessType(tag);
        this.config.readFromNBT(tag.func_74775_l("config"));
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
        this.markNetworkNodeDirty();
        if (this.network != null) {
            this.network.getItemStorageCache().sort();
            this.network.getFluidStorageCache().sort();
        }
    }

    public void updateStorage(INetwork network) {
        this.itemStorages.clear();
        this.fluidStorages.clear();
        TileEntity facing = this.getFacingTile();
        if (facing != null) {
            if (this.config.isFilterTypeItem()) {
                for (IExternalStorageProvider<?> provider : API.instance().getExternalStorageProviders(StorageType.ITEM)) {
                    if (!provider.canProvide(facing, this.getDirection())) continue;
                    this.itemStorages.add(provider.provide(this, this::getFacingTile, this.getDirection()));
                    break;
                }
            } else if (this.config.isFilterTypeFluid()) {
                for (IExternalStorageProvider<?> provider : API.instance().getExternalStorageProviders(StorageType.FLUID)) {
                    if (!provider.canProvide(facing, this.getDirection())) continue;
                    this.fluidStorages.add(provider.provide(this, this::getFacingTile, this.getDirection()));
                    break;
                }
            }
        }
        network.getNodeGraph().runActionWhenPossible(StorageCacheItem.INVALIDATE);
        network.getNodeGraph().runActionWhenPossible(StorageCacheFluid.INVALIDATE);
    }

    @Override
    public void addItemStorages(List<IStorage<ItemStack>> storages) {
        storages.addAll(this.itemStorages);
    }

    @Override
    public void addFluidStorages(List<IStorage<FluidStack>> storages) {
        storages.addAll(this.fluidStorages);
    }

    @Override
    public String getGuiTitle() {
        return "gui.refinedstorage:external_storage";
    }

    @Override
    public TileDataParameter<Integer, ?> getRedstoneModeParameter() {
        return TileExternalStorage.REDSTONE_MODE;
    }

    @Override
    public TileDataParameter<Integer, ?> getCompareParameter() {
        return TileExternalStorage.COMPARE;
    }

    @Override
    public TileDataParameter<Integer, ?> getFilterParameter() {
        return TileExternalStorage.MODE;
    }

    @Override
    public TileDataParameter<Integer, ?> getPriorityParameter() {
        return TileExternalStorage.PRIORITY;
    }

    @Override
    public TileDataParameter<AccessType, ?> getAccessTypeParameter() {
        return TileExternalStorage.ACCESS_TYPE;
    }

    @Override
    public long getStored() {
        return TileExternalStorage.STORED.getValue();
    }

    @Override
    public long getCapacity() {
        return TileExternalStorage.CAPACITY.getValue();
    }

    @Override
    public AccessType getAccessType() {
        return this.accessType;
    }

    @Override
    public boolean acceptsItem(ItemStack stack) {
        return this.config.acceptsItem(stack);
    }

    @Override
    public boolean acceptsFluid(FluidStack stack) {
        return this.config.acceptsFluid(stack);
    }

    @Override
    public void setAccessType(AccessType type) {
        this.accessType = type;
        if (this.network != null) {
            this.network.getItemStorageCache().invalidate();
            this.network.getFluidStorageCache().invalidate();
        }
        this.markNetworkNodeDirty();
    }

    @Override
    public TileDataParameter<Integer, ?> getTypeParameter() {
        return TileExternalStorage.TYPE;
    }

    public List<IStorageExternal<ItemStack>> getItemStorages() {
        return this.itemStorages;
    }

    public List<IStorageExternal<FluidStack>> getFluidStorages() {
        return this.fluidStorages;
    }

    @Override
    public boolean canConduct(@Nullable EnumFacing direction) {
        return this.coverManager.canConduct(direction);
    }

    @Override
    @Nullable
    public IItemHandler getDrops() {
        return this.coverManager.getAsInventory();
    }

    @Override
    public CoverManager getCoverManager() {
        return this.coverManager;
    }

    @Override
    @Nonnull
    public FilterConfig getConfig() {
        return this.config;
    }
}

